/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.IVWConsole;
import filenet.vw.base.logging.IVWConsoleHandler;
import filenet.vw.base.logging.Level;
import filenet.vw.rmi.VWUnicastRemoteObject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class VWLogger
extends VWUnicastRemoteObject
implements IVWConsoleHandler {
    public static final int NONE = Level.OFF.intValue();
    public static final int ERROR = Level.SEVERE.intValue();
    public static final int WARNING = Level.WARNING.intValue();
    public static final int INFORMATION = Level.INFO.intValue();
    public static final int DEBUG1 = Level.FINE.intValue();
    public static final int DEBUG2 = Level.FINER.intValue();
    public static final int DEBUG3 = Level.FINEST.intValue();
    private PrintStream s_printStream = null;
    private int s_logLevel = NONE;
    protected Vector fileNames = null;
    protected Vector fileLogLevel = null;
    protected Vector consoles = null;
    protected Vector consoleLogLevel = null;
    protected SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
    private static final long serialVersionUID = 7444L;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 19:12:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    public void setSystemErr(int logLevel) {
        this.s_printStream = System.err;
        this.s_logLevel = logLevel;
    }

    public void setDebugStream(PrintStream stream, int logLevel) {
        this.s_printStream = stream;
        this.s_logLevel = logLevel;
    }

    public void setFileToLog(String fileName, int logLevel) throws RemoteException, VWException {
        try {
            if (this.fileNames == null) {
                this.fileNames = new Vector();
                this.fileLogLevel = new Vector();
            }
            if (!this.fileNames.contains(fileName)) {
                this.fileNames.addElement(fileName);
                this.fileLogLevel.addElement(new Integer(logLevel));
            } else {
                int inx = this.fileNames.indexOf(fileName);
                this.fileLogLevel.insertElementAt(new Integer(logLevel), inx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeFileToLog(String fileName) throws RemoteException, VWException {
        if (this.fileNames != null && this.fileNames.contains(fileName)) {
            int inx = this.fileNames.indexOf(fileName);
            this.fileNames.removeElement(fileName);
            this.fileLogLevel.removeElementAt(inx);
        }
    }

    public String[] listFilesLogging() throws RemoteException, VWException {
        Object[] files = null;
        if (this.fileNames != null) {
            files = new String[this.fileNames.size()];
            this.fileNames.copyInto(files);
        }
        return files;
    }

    public int getMessageLevel(String fileName) throws RemoteException, VWException {
        int logLevel = NONE;
        if (this.fileNames != null && this.fileNames.contains(fileName)) {
            int inx = this.fileNames.indexOf(fileName);
            logLevel = (Integer)this.fileLogLevel.elementAt(inx);
        }
        return logLevel;
    }

    public void logException(Exception e) {
        this.logException(e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void logException(Exception e, String extraInformation) {
        int i;
        if (this.s_printStream != null && this.s_logLevel != NONE) {
            if (e != null) {
                e.printStackTrace(this.s_printStream);
            }
            if (extraInformation != null) {
                this.s_printStream.println(extraInformation);
            }
        }
        if (this.fileNames != null) {
            PrintWriter oFile = null;
            for (i = 0; i < this.fileNames.size(); ++i) {
                block20: {
                    if ((Integer)this.fileLogLevel.elementAt(i) == NONE) break block20;
                    oFile = new PrintWriter(new BufferedWriter(new FileWriter((String)this.fileNames.elementAt(i), true)));
                    oFile.println(this.dateFormatter.format(new Date()));
                    if (e != null) {
                        e.printStackTrace(oFile);
                    }
                    if (extraInformation != null) {
                        oFile.println(extraInformation);
                    }
                    oFile.flush();
                }
                Object var7_8 = null;
                if (oFile == null) continue;
                try {
                    oFile.close();
                }
                catch (Exception ignore) {}
                continue;
                {
                    catch (Exception ex) {
                        var7_8 = null;
                        if (oFile == null) continue;
                        try {
                            oFile.close();
                        }
                        catch (Exception ignore) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_8 = null;
                    if (oFile != null) {
                        try {
                            oFile.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (this.consoles != null) {
            IVWConsole console = null;
            for (i = 0; i < this.consoles.size(); ++i) {
                try {
                    if ((Integer)this.consoleLogLevel.elementAt(i) == NONE) continue;
                    console = (IVWConsole)this.consoles.elementAt(i);
                    console.writeException(e, extraInformation);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void logError(String info) {
        this.log(ERROR, info);
    }

    public void logWarning(String info) {
        this.log(WARNING, info);
    }

    public void logInfo(String info) {
        this.log(INFORMATION, info);
    }

    public void logDebug1(String info) {
        this.log(DEBUG1, info);
    }

    public void logDebug2(String info) {
        this.log(DEBUG2, info);
    }

    public void logDebug3(String info) {
        this.log(DEBUG3, info);
    }

    public boolean nullCheck(Object theObject) throws RemoteException, VWException {
        if (theObject == null) {
            this.logError("Null not expected.");
            return false;
        }
        return true;
    }

    public void log(int logType, String info) {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append(this.dateFormatter.format(new Date())).append(" <").append(logType).append("> [");
        buf.append(Thread.currentThread().getName()).append("] - ").append(info);
        if (this.s_printStream != null && logType >= this.s_logLevel && this.s_logLevel != NONE) {
            this.s_printStream.println(buf.toString());
            if (logType >= WARNING) {
                Throwable throwable = new Throwable();
                throwable.printStackTrace(this.s_printStream);
            }
        }
        if (this.fileNames != null) {
            for (i = 0; i < this.fileNames.size(); ++i) {
                try {
                    if (logType < (Integer)this.fileLogLevel.elementAt(i)) continue;
                    PrintWriter oFile = new PrintWriter(new BufferedWriter(new FileWriter((String)this.fileNames.elementAt(i), true)));
                    oFile.println(buf.toString());
                    oFile.flush();
                    if (logType >= WARNING) {
                        Throwable throwable = new Throwable();
                        throwable.printStackTrace(oFile);
                    }
                    oFile.flush();
                    oFile.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.consoles != null) {
            IVWConsole console = null;
            for (i = 0; i < this.consoles.size(); ++i) {
                try {
                    if (logType < (Integer)this.consoleLogLevel.elementAt(i)) continue;
                    console = (IVWConsole)this.consoles.elementAt(i);
                    console.writeMessage(this.getLevelObject(logType), buf.toString());
                    continue;
                }
                catch (RemoteException e) {
                    try {
                        this.removeApplicationFromRegistry(console);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void changeMessageLevel(int level) throws RemoteException, VWException {
        if (this.consoles != null) {
            Object console = null;
            for (int i = 0; i < this.consoles.size(); ++i) {
                this.consoleLogLevel.insertElementAt(new Integer(level), i);
            }
        }
    }

    private void removeApplicationFromRegistry(IVWConsole theConsole) throws RemoteException, VWException {
        if (this.consoles != null && this.consoles.contains(theConsole)) {
            int inx = this.consoles.indexOf(theConsole);
            this.consoles.removeElement(theConsole);
            this.consoleLogLevel.removeElementAt(inx);
        }
    }

    public Level getLevelObject(int level) {
        if (level == NONE) {
            return Level.OFF;
        }
        if (level == ERROR) {
            return Level.SEVERE;
        }
        if (level == WARNING) {
            return Level.WARNING;
        }
        if (level == INFORMATION) {
            return Level.INFO;
        }
        if (level == DEBUG1) {
            return Level.FINE;
        }
        if (level == DEBUG2) {
            return Level.FINER;
        }
        if (level == DEBUG3) {
            return Level.FINEST;
        }
        return null;
    }

    public void addConsole(IVWConsole object, Level level) throws RemoteException, VWException {
        try {
            if (this.consoles == null) {
                this.consoles = new Vector();
                this.consoleLogLevel = new Vector();
            }
            if (!this.consoles.contains(object)) {
                this.consoles.addElement(object);
                this.consoleLogLevel.addElement(new Integer(level.intValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addConsole(IVWConsole object, int level) throws RemoteException, VWException {
        try {
            if (this.consoles == null) {
                this.consoles = new Vector();
                this.consoleLogLevel = new Vector();
            }
            if (!this.consoles.contains(object)) {
                this.consoles.addElement(object);
                this.consoleLogLevel.addElement(new Integer(level));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeConsole(IVWConsole theConsole) throws RemoteException, VWException {
        if (this.consoles != null && this.consoles.contains(theConsole)) {
            int inx = this.consoles.indexOf(theConsole);
            this.consoles.removeElement(theConsole);
            this.consoleLogLevel.removeElementAt(inx);
        }
    }

    public void setConsoleLevel(IVWConsole theConsole, Level level) throws RemoteException, VWException {
        if (this.consoles != null && this.consoles.contains(theConsole)) {
            int inx = this.consoles.indexOf(theConsole);
            this.consoleLogLevel.insertElementAt(new Integer(level.intValue()), inx);
        }
    }

    public void setConsoleLevel(IVWConsole theConsole, int level) throws RemoteException, VWException {
        if (this.consoles != null && this.consoles.contains(theConsole)) {
            int inx = this.consoles.indexOf(theConsole);
            this.consoleLogLevel.insertElementAt(new Integer(level), inx);
        }
    }

    public Level getConsoleLevel(IVWConsole theConsole) throws RemoteException, VWException {
        int result = 0;
        if (this.consoles != null && this.consoles.contains(theConsole)) {
            int inx = this.consoles.indexOf(theConsole);
            result = (Integer)this.consoleLogLevel.elementAt(inx);
        }
        return this.getLevelObject(result);
    }

    public int getIntConsoleLevel(IVWConsole theConsole) throws RemoteException, VWException {
        int result = 0;
        if (this.consoles != null && this.consoles.contains(theConsole)) {
            int inx = this.consoles.indexOf(theConsole);
            result = (Integer)this.consoleLogLevel.elementAt(inx);
        }
        return result;
    }
}

